#include <bits/stdc++.h>
using namespace std;

// Funkcija za izracunavanje kombinacija C(k,2) = k*(k-1)/2
long long C2(long long k) {
    return k * (k - 1) / 2;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    // Mape za prebrojavanje tacaka po dijagonalama
    map<long long, long long> diag_sum;   // x + y
    map<long long, long long> diag_diff;  // x - y

    for (int i = 0; i < n; i++) {
        long long x, y;
        cin >> x >> y;

        diag_sum[x + y]++;   // Broji koliko takmicara startuje na istoj x+y dijagonali
        diag_diff[x - y]++;  // Broji koliko takmicara startuje na istoj x-y dijagonali
    }

    long long ans = 0;

    // Za svaku dijagonalu brojimo koliko parova ce se susresti
    for (auto &p : diag_sum)
        ans += 2 * C2(p.second);  // svaki par daje jedan susret na ovoj dijagonali

    for (auto &p : diag_diff)
        ans += 2 * C2(p.second);  // isti princip za x-y dijagonale

    cout << ans << "\n";
    return 0;
}